function [Control_laws,wmax,Pnom] = control_values(wind,Vnom,Vcutin,...
    rr,Tavg,om)
%% ESTRAZIONE VARIABILI DI CONTROLLO (MEDIE SU RIVOLUZIONE).
Pavg = (Tavg'.*om)';
Pnom = max(Pavg(:,Vnom));
iwmax = find(Pnom == Pavg(:,Vnom));
wmax = om(iwmax);
PMAX = zeros(size(wind));
TNOM = zeros(size(wind));
imax = zeros(size(wind));
wnom = zeros(size(wind));
dw = 0.05;
%% Estrazione punti a massima efficienza
flag = 1;
for ii = 1:25
    P1 = Pavg(:,ii);
    PMAX(ii) = max(P1);
    imax(ii) = find(P1==PMAX(ii));
    T1 = Tavg(:,ii);
    TNOM(ii) = T1(imax(ii));
    wnom(ii) = om(imax(ii));
    if ii>1
        if TNOM(ii)<TNOM(ii-1)
            TNOM(ii) = TNOM(ii-1)+2;
        end
        if wnom(ii) == om(imax(ii-1))
            wnom(ii) = wnom(ii) + flag*dw;
            flag = flag + 1;
        end
    end
    %     FX1 = FX(:,ii);
end
coeffT = polyfit(wnom,TNOM,2);
curveT = @(w) coeffT(1).*w.^2+coeffT(2).*w+coeffT(3);
tsrott = wmax*rr/Vnom;
wsoglia = tsrott*Vcutin/rr;
clawT = zeros(size(wnom));
for jj = 1:length(wnom)
    if wnom(jj)<wsoglia
        clawT(jj) = 0;
    else
        if wnom(jj)>wmax
            clawT(jj) = Pnom/wnom(jj);
            
        else
            clawT(jj) = curveT(wnom(jj));
        end
    end
end
Control_laws.w1 = wnom;
Control_laws.T1 = clawT;